#include "stdafx.h"
#include "lemfc.h"
#include "lemfc_1.h"
#include "lemfc_1d.h"
#include "lemfc_1v.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLemfc_1View

IMPLEMENT_DYNCREATE(CLemfc_1View, CLEditView)

BEGIN_MESSAGE_MAP(CLemfc_1View, CLEditView)
	//{{AFX_MSG_MAP(CLemfc_1View)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	// Standard printing commands
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLemfc_1View construction/destruction

CLemfc_1View::CLemfc_1View()
{
	// TODO: add construction code here
	m_clrBackColor = RGB(192,192,192);
	m_clrForeColor = RGB(0,0,0);
	m_clrBackColorSelected = RGB(255,0,0);
	m_clrForeColorSelected = RGB(255,255,255);
}

CLemfc_1View::~CLemfc_1View()
{
}                              

// Handles highlight of every single word. Neesa ES_HIGHLIGHT
void 
CLemfc_1View::OnControlHighlight(WORDDESC& WD, CDC* pDC)
{
   switch (WD.wCode)
   {
     
     case WD_QUOTEDTEXT:
     case WD_BADLYQUOTEDTEXT:
       pDC->SetTextColor(RGB(0,128,0));
       break;
     case WD_SIMPLEWORD:            
       if (lstrcmpi(WD.caWord,"HREF") == 0)
         {
           pDC->SetTextColor(RGB(255,0,0));
           break; 
         }
     default:
       pDC->SetTextColor(RGB(0,0,255));
       break; 
     case WD_SYNTAXITEM:
       pDC->SetTextColor(RGB(255,255,255));
   }
}
   

/////////////////////////////////////////////////////////////////////////////
// CLemfc_1View diagnostics

#ifdef _DEBUG
void CLemfc_1View::AssertValid() const
{
	CView::AssertValid();
}

void CLemfc_1View::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CLemfc_1Doc* CLemfc_1View::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CLemfc_1Doc)));
	return (CLemfc_1Doc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CLemfc_1View message handlers

int CLemfc_1View::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CLEditView::OnCreate(lpCreateStruct) == -1)
		return -1;     
		
	GetLEditCtrl().SetHighlight(TRUE); // Highlighting == YES!!!
	GetLEditCtrl().SetMultilineItems(TRUE); // Must be before SetStartInComments
	GetLEditCtrl().SetStartInComments(TRUE);
	GetLEditCtrl().SetSyntax("2\"\\001>1<1=");
	GetLEditCtrl().SetWordWrap();
	GetLEditCtrl().SetScrollBars(FALSE,TRUE);
	
	return 0;
}
